
% Code to analize the Martha Zuniga data.
datafiles = { ...
'data/221_00000000XptlX1_xy.dat', ...
'data/911_01183800_pt4_xy.dat', ...
'data/Z1_003224_pt1_xy.dat', ...
'data/Z4_001600_pt1_xy.txt'};

datafiles = { ...
'../data/221_00000000XptlX1_xy.dat', ...
'../data/221_00000000XptlX3_xy.dat', ...
'../data/221_000092806XptlX1a_xy.dat', ...
'../data/221_00061418XptlX2_xy.dat', ...
'../data/911_001255104XptlX4_xy.dat', ...
'../data/911_00542314rtXptlX6_xy.dat', ...
'../data/911_01183800_pt4_xy.dat', ...
'../data/911_01353510ptlX4_xy.dat', ...
'../data/C48_012940_pt1b_xy.dat', ...
'../data/C48_013812_pt3_xy.dat', ...
'../data/C48_014210_pt1_xy.dat', ...
'../data/C48_015022_pt2a_xy.dat', ...
'../data/wildtypeLd_00435612XptlX1_x.dat', ...
'../data/wtLd_00212.50_xy.dat', ...
'../data/wtLd_003650.10_xy.dat', ...
'../data/wtLd_00435612Xptl1_xy.dat', ...
'../data/Z1_003224_pt1_xy.dat', ...
'../data/Z1_003224_pt2_xy.txt', ...
'../data/Z1_00.42.33_pt1_xy.txt', ...
'../data/Z1_00.46.00_Pt1_xy.dat', ...
'../data/Z2_00.09.20_Pt1_xy.dat', ...
'../data/Z2_00.10.11_Pt1_xy.txt', ...
'../data/Z2_00.13.23_Pt2_xy.txt', ...
'../data/Z2_00.14.45_pt2_xy.txt', ...
'../data/Z2_00.18.58_Pt1_xy.txt', ...
'../data/Z3_004731_pt1b_xy.txt', ...
'../data/Z3_004950_pt1_xy.txt', ...
'../data/Z3_005430_pt2_xy.txt', ...
'../data/Z3_010100_pt1_xy.txt', ...
'../data/Z3_010444_pt1_xy.txt', ...
'../data/Z4_0001_pt1_xy.txt', ...
'../data/Z4_0003_pt1_xy.txt', ...
'../data/Z4_001600_pt1_xy.txt'};

names = strrep(strrep(datafiles, 'data/', ''), '_', '\_');
close all % Close all figures
fclose('all');
fid = fopen('plots/diffcons','w');
dt = 1/30*10^6;
holdCDF = [];
holdFit = [];
for i=1:length(datafiles)
   W = dlmread(datafiles{i},' ');
   x = W(:,1);
   y = W(:,2);
   x = x-x(1);
   y = y-y(1);
   figure
   set(gca,'fontsize',20)
   plot(x,y)
   xlabel('x (nm)')
   ylabel('y (nm)')
   title(['Probe Path ', num2str(i)])
%   filename = strrep(names{i},'\_','_');
%   filename = strrep(filename,'../','Paths/');
%   filename = strrep(filename,'dat','eps');
%   filename = strrep(filename,'txt','eps');
   filename = ['Paths/Path',num2str(i)];
   print('-depsc2', filename);
end

% (x,y)   The coordinates of the paths
% dt      Time step in micro-seconds
% jumps   The jump sizes in increasing order
% angles  The angles between segments in increasing order
